//	CDocument.c

#ifndef _H_CDocument
#define _H_CDocument

#include "CWindow.h"

#define	kHScrollID			128
#define	kVScrollID			129
#define	kScrollbarWidth		16

class CDocument : public CWindow {

	public:		Boolean	IDocument(
					ADFS_WindowType windowType, 
					short			resourceID
				);
	
	virtual		void	Dispose(void);
	
	virtual		void	DoKeyDown(EventRecord *event);
	virtual		void	DoClick(EventRecord *event);
	virtual		void	ReActivate(Boolean active);
	virtual		void	Draw(void);
	virtual		void	Size(EventRecord *event);
	virtual		void	Zoom(EventRecord *event, short direction);
	virtual		Rect	GetWindowRect(WindowRectType wrType);

	virtual		Boolean	WillScrollOffset(
		ControlRef	theControl, 
		short		offset);

	virtual		void	SetScrollOffset(
		ControlRef	theControl, 
		short		offset);

	virtual		void	DeSelectAll(void);
	virtual		Rect	MarqueeSelect(Point	hitPoint, ulong modifiers);

	virtual		void	AdjustScrollbars(void);
	
	virtual		void	GetLineAndPageScrolls(
		WindowRectType	scrollbar, 
		short			*line, 
		short			*page
	);
	
	virtual		void	LiveResize(void);
	virtual		Rect	GetScrollExtents(void);

	virtual		void	GetScrollMaxs(
		short	*hMax, 
		short	*vMax
	);

	virtual		Boolean	GetScrollbarHit(
		Point			thePoint, 
		WindowRectType	*pane, 
		short			*subPane, 
		Rect			*hitRect
	);
	
	static	pascal	void	ScrollActionCB(
		ControlRef	theControl, 
		short		controlPart);

	virtual		void	ScrollAction(
		ControlRef	theControl, 
		short		controlPart);

	virtual		void	ThumbAction(
		ControlRef theControl, short origValueS);
		
	static pascal void	ThumbActionCB(
		ControlRef	theControl, 
		short		controlPart);
	
	virtual	void	Update(void);

	Boolean				i_scrollingB;
	Boolean				i_prepared;
	ControlRef			i_hScrollbar;
	ControlRef			i_vScrollbar;
	
	void			SetPTitle(unsigned char *nameZu);
	Boolean		IsUntitled();
	void		SetUntitled();
	FSSpec		i_fileSpec;

	private:
	typedef CWindow	_inherited;
};

#endif